#pragma once

#include <yplatform/active/pool.h>

namespace yplatform { namespace active {

template <typename Handler>
class callback
{
public:
    callback(boost::shared_ptr<pool> pool, Handler h, prio_t prio = 1)
        : pool_(pool), h_(h), prio_(prio)
    {
    }

    static void do_nothing()
    {
    }

    void operator()()
    {
        pool_->enqueue_method(h_, &do_nothing, prio_);
    }

private:
    boost::shared_ptr<pool> pool_;
    Handler h_;
    prio_t prio_;
};

template <typename Handler>
callback<Handler> make_callback(boost::shared_ptr<pool> pool, Handler h, prio_t prio = 1)
{
    return callback<Handler>(pool, h, prio);
}

}}
