#pragma once

#include <yplatform/module.h>
#include <yplatform/active/pool.h>
#include <boost/noncopyable.hpp>

namespace yplatform { namespace active {

using yplatform::future::future;
using yplatform::future::promise;

class object
    : public module
    , public boost::noncopyable
{
    object_context* core_create_context() const
    {
        return create_context();
    }

protected:
    virtual object_context* create_context(void) const
    {
        return 0;
    }

public:
    object()
    {
    }

    virtual ~object()
    {
        this->close();
    }

    template <typename HOOK, typename CANCEL>
    bool enqueue_method(
        const HOOK& hook,
        const CANCEL& cancel,
        const prio_t& prio = 1,
        const ptime& deadline = boost::posix_time::pos_infin)
    {
        return pool_->enqueue_method(hook, cancel, prio, deadline);
    }

    void set_capacity(size_t capacity)
    {
        pool_->set_capacity(capacity);
    }

    boost::asio::io_service& timer_service()
    {
        return pool_->timer_service();
    }

protected:
    bool close(void)
    {
        return pool_->close();
    }

    void init_pool()
    {
        pool_.reset(new pool(250, name(), get_enqueue_timeout()));
        pool_->create_ctx_hook(boost::bind(&object::core_create_context, this));
    }

    bool open(unsigned __nthr)
    {
        if (!pool_.get()) pool_.reset(new pool(250, name(), get_enqueue_timeout()));
        return pool_->open(__nthr);
    }

    void cancel(method_proxy_base* __e)
    {
        pool_->cancel(__e);
    }

    virtual const yplatform::active::time_duration get_enqueue_timeout() const
    {
        return yplatform::active::time_duration(0, 0, 0, 0);
    }

private:
    std::unique_ptr<yplatform::active::pool> pool_;
};

}}
