#pragma once

#include <boost/thread.hpp>
#include <boost/function.hpp>

namespace yplatform { namespace active {

using boost::thread;

class task
{
public:
    task(const boost::function<void()>& __func) : func_(__func)
    {
    }
    task(void)
    {
    }

    virtual ~task()
    {
        this->close();
    }

    void set_function(const boost::function<void()>& __func)
    {
        this->func_ = __func;
    }

    virtual bool open(unsigned __nthreads)
    {
        assert(!this->threads_.get()); // detect if twice opened
        this->threads_.reset(new boost::thread_group());
        while (__nthreads--)
            this->threads_->create_thread(this->func_);

        return true;
    }

    virtual bool close(void)
    {
        if (this->threads_.get())
        {
            this->threads_->join_all();
            this->threads_.reset();
        }

        return true;
    }

    void new_size(unsigned __nthreads);
    size_t increment(unsigned int __delta);
    size_t decrement(unsigned int __delta);

private:
    std::unique_ptr<boost::thread_group> threads_;
    boost::function<void()> func_;
};

}}
