#pragma once

#include <random>
#include <vector>

namespace yplatform {

class weighted_random_select
{
public:
    weighted_random_select() : rd_(), gen_(rd_())
    {
    }

    size_t operator()(const std::vector<double>& weights)
    {
        std::discrete_distribution<> d(weights.begin(), weights.end());
        return d(gen_);
    }

private:
    std::random_device rd_;
    std::mt19937 gen_;
};

}
