#pragma once

#include <yplatform/application/pid_file.h>
#include <yplatform/application/configuration.h>
#include <yplatform/application/context_repository.h>
#include <yplatform/application/find.h>
#include <yplatform/reactor/reactor.h>
#include <yplatform/log/detail/service.h>
#include <paths.h>
#include <syslog.h>

namespace yplatform {

inline void log_fatal_error(const string& reason)
{
    try
    {
        YLOG_GLOBAL(fatal) << reason;
    }
    catch (...)
    {
    }
    std::cerr << "fatal error: " << reason << "\n";
    openlog("yplatform", 0, LOG_DAEMON);
    syslog(LOG_CRIT, "fatal error: %s", reason.c_str());
}

class load_error : public std::runtime_error
{
public:
    load_error(const std::string& message) : std::runtime_error(message)
    {
    }
};

class runtime_error : public std::runtime_error
{
public:
    runtime_error(const std::string& message) : std::runtime_error(message)
    {
    }
};

class application
{
public:
    application();

    application(const configuration& config);

    ~application();

    void run();

    void reload(const configuration& config);

    void stop(int signal = 0);

private:
    void core_stop();
    void core_cleanup();
    void load(const configuration& config);

    std::unique_ptr<pid_file> pid_;
    repository* global_repository_; // refers to global object, for debug only
    reactor_set_ptr reactors_;
};

}
