#pragma once

#include <yplatform/application/task_context.h>
#include <yplatform/config.h>
#include <yplatform/api.h>
#include <boost/unordered_set.hpp>
#include <boost/noncopyable.hpp>

#define context_repo yplatform::context_repository::instance()

namespace yplatform {

struct context_repository_impl;
typedef boost::shared_ptr<context_repository_impl> context_repository_impl_ptr;

class context_repository
{
public:
    typedef boost::shared_ptr<task_context_list> table_ptr;

    context_repository();

    API_PUBLIC void add_context(task_context_ptr context);
    API_PUBLIC void rem_context(task_context_ptr context);
    API_PUBLIC table_ptr get_contexts();
    API_PUBLIC void wait_for_finish();

    API_PUBLIC static context_repository& instance();
    API_PUBLIC static std::shared_ptr<context_repository> instance_ptr();

private:
    context_repository_impl_ptr impl;
};

} // namespace yplatform
