#pragma once

#include <yplatform/application/configuration.h>
#include <yplatform/application/repository.h>
#include <yplatform/application/context_repository.h>
#include <yplatform/reactor/reactor.h>
#include <yplatform/log/detail/service.h>

namespace yplatform {

inline void init_global_reactors(const configuration& config)
{
    global_reactor_set = boost::make_shared<reactor_set>();
    for (auto& pair : config.io_cfg())
    {
        global_reactor_set->add(pair.first, pair.second);
    }
    global_net_reactor = global_reactor_set->get_global();
}

inline void init_global_repository(reactor_set_ptr reactors, const configuration& config)
{
    repository::instance().init(reactors, config);
}

inline void init_global_context_repository()
{
    context_repository::instance();
}

}
