#pragma once

#include <yplatform/application/find.h>
#include <yplatform/application/module.h>

template <typename T>
struct module_registrator
{
    module_registrator(const std::string& name)
    {
        yplatform::global_factory::add_factory<T>(name);
    }
};

// Preprocessor stringifizing magic, for details look here:
// http://stackoverflow.com/a/1489985/3130355
#define CONCATENATION_PASTER(x, y) x##y
#define CONCATENATION_EVALUATOR(x, y) CONCATENATION_PASTER(x, y)

#define DEFINE_SERVICE_OBJECT_BEGIN() namespace {

#define DEFINE_SERVICE_OBJECT_MODULE(type)                                                         \
    static module_registrator<::type> CONCATENATION_EVALUATOR(module_registrator_, __COUNTER__)(   \
        #type);

#define DEFINE_SERVICE_OBJECT_END() }

/*Result will look like:
  namespace {
    static module_registrator< my_object > module_registrator_XX( "my_object" );
  }

  Where XX is different for every invocation of macro in same compilation unit.
*/
#define DEFINE_SERVICE_OBJECT(type)                                                                \
    DEFINE_SERVICE_OBJECT_BEGIN()                                                                  \
    DEFINE_SERVICE_OBJECT_MODULE(type)                                                             \
    DEFINE_SERVICE_OBJECT_END()

#define REGISTER_MODULE(type) DEFINE_SERVICE_OBJECT(type)

#define REGISTER_MODULES_BEGIN() DEFINE_SERVICE_OBJECT_BEGIN()
#define REGISTER_MODULES_ADD(type) DEFINE_SERVICE_OBJECT_MODULE(type)
#define REGISTER_MODULES_END() DEFINE_SERVICE_OBJECT_END()
