#pragma once

#include <yplatform/string_config.h>
#include <boost/filesystem/operations.hpp>
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <fstream>
#include <stdexcept>

namespace yplatform {

class pid_file
{
public:
    pid_file(const string& file_name) : file_name_(file_name)
    {
        if (file_name_.empty()) return;
        boost::filesystem::create_directories(boost::filesystem::path(file_name_).parent_path());
        std::ofstream s(file_name_.c_str());
        s << getpid() << "\n";
        if (!s.is_open() || !s.good())
        {
            throw std::runtime_error("cannot write into " + file_name_);
        }
    }

    ~pid_file()
    {
        if (!file_name_.empty()) ::unlink(file_name_.c_str());
    }

private:
    string file_name_;
};

}
