#pragma once

#include <yplatform/string_config.h>
#include <stdexcept>
#include <boost/exception/all.hpp>
#include <boost/exception/error_info.hpp>
#include <yplatform/exception.h>

namespace yplatform { namespace convert {

struct error
    : public std::runtime_error
    , public boost::exception
{
    inline explicit error(const string& __arg) : std::runtime_error(__arg)
    {
    }

    inline virtual ~error()
    {
    }
};

struct illegal_sequence_error : public error
{
    inline explicit illegal_sequence_error(const string& arg) : error(arg)
    {
    }
};

struct bad_args_error : public error
{
    inline explicit bad_args_error(const string& arg) : error(arg)
    {
    }
};

struct not_supported_error : public error
{
    inline explicit not_supported_error(const string& arg) : error(arg)
    {
    }
};

struct engine_error : public error
{
    inline explicit engine_error(const string& arg) : error(arg)
    {
    }
};

struct algo_error : public error
{
    inline explicit algo_error(const string& arg) : error(arg)
    {
    }
};

typedef boost::error_info<struct tag_errno, int> errno_info;

}}
