#pragma once

#include <yplatform/string_config.h>

#include <boost/shared_ptr.hpp>

namespace yplatform { namespace convert { namespace detail {

// interface to iconv (3)
class iconv_impl
{
public:
    typedef char CHAR;

    iconv_impl(const string& __to, const string& __from);
    bool operator()(CHAR*& __i, size_t& __isz, CHAR*& __o, size_t& __osz);

    void reset()
    {
        CHAR* i = 0;
        CHAR* o = 0;
        size_t isz = 0;
        size_t osz = 0;
        this->operator()(i, isz, o, osz);
    }

private:
    class impl;
    boost::shared_ptr<impl> ic_;
};

}}}
