#pragma once

#include <yplatform/string_config.h>
#include <yplatform/convert/iconv_impl.h>
#include <yplatform/convert/error.h>

#ifndef ICBUFSZ
#define ICBUFSZ (6)
#endif

#ifndef ICIBUFSZ
#define ICIBUFSZ ICBUFSZ
#endif

#ifndef ICOBUFSZ
#define ICOBUFSZ ICBUFSZ
#endif

namespace yplatform { namespace convert {

template <class IconvImpl, typename InputIterator, typename OutputIterator>
OutputIterator iconvert(
    IconvImpl __impl,
    size_t __isz,
    size_t __osz,
    InputIterator __first,
    InputIterator __last,
    OutputIterator __result);

template <class IconvImpl, typename InputIterator, typename OutputIterator>
OutputIterator iconvert(
    IconvImpl __impl,
    size_t __isz,
    size_t __osz,
    InputIterator __first,
    InputIterator __last,
    OutputIterator __result,
    OutputIterator __end);

template <class IconvImpl, typename InputIterator, typename OutputIterator>
inline OutputIterator iconvert(
    IconvImpl __impl,
    InputIterator __first,
    InputIterator __last,
    OutputIterator __result)
{
    return iconvert<detail::iconv_impl, InputIterator, OutputIterator>(
        __impl, ICIBUFSZ, ICOBUFSZ, __first, __last, __result);
}

template <class IconvImpl, typename InputIterator, typename OutputIterator>
inline OutputIterator iconvert(
    IconvImpl __impl,
    InputIterator __first,
    InputIterator __last,
    OutputIterator __result,
    OutputIterator __end)
{
    return iconvert<detail::iconv_impl, InputIterator, OutputIterator>(
        __impl, ICIBUFSZ, ICOBUFSZ, __first, __last, __result, __end);
}

template <typename InputIterator, typename OutputIterator>
inline OutputIterator iconvert(
    const string& __to,
    const string& __from,
    InputIterator __first,
    InputIterator __last,
    OutputIterator __result,
    OutputIterator __end)
{
    detail::iconv_impl ii(__to, __from);
    return iconvert<detail::iconv_impl, InputIterator, OutputIterator>(
        ii, __first, __last, __result, __end);
}

template <typename InputIterator, typename OutputIterator>
inline OutputIterator iconvert(
    const string& __to,
    const string& __from,
    InputIterator __first,
    InputIterator __last,
    OutputIterator __result)
{
    detail::iconv_impl ii(__to, __from);
    return iconvert<detail::iconv_impl, InputIterator, OutputIterator>(
        ii, __first, __last, __result);
}

template <class String>
String iconvert_string(const string& __to, const string& __from, const String& __src)
{
    String out;
    (void)iconvert(__to, __from, __src.begin(), __src.end(), std::back_inserter(out));
    return out;
}

}}

#include <yplatform/convert/yconv.inl>
