#pragma once

#include <boost/system/error_code.hpp>
#include <type_traits>

namespace yplatform {

template <typename T>
struct is_error_enum;

namespace detail {

template <typename ErrorCodeEnum, typename T>
using enable_if_error_enum = std::enable_if_t<is_error_enum<ErrorCodeEnum>::value, T>;

template <typename T, typename = void>
struct is_error_code : std::false_type
{
};

template <typename T>
struct is_error_code<
    T,
    std::void_t<
        decltype(std::declval<T>().message()),
        decltype(std::declval<T>().value()),
        decltype(std::declval<T>().category()),
        decltype(std::declval<T>().default_error_condition())>> : std::true_type
{
};

template <typename ErrorCode, typename T>
using enable_if_error_code = std::enable_if_t<is_error_code<ErrorCode>::value, T>;

template <typename T, typename = void>
struct has_method_what : std::false_type
{
};

template <typename T>
struct has_method_what<T, std::void_t<decltype(std::declval<T>().what())>> : std::true_type
{
};

}

}
