#pragma once

#include <yplatform/range.h>
#include <yplatform/encoding/iterators/transform_width.h>
#include <yplatform/encoding/iterators/base64_from_binary.h>
#include <yplatform/encoding/iterators/binary_from_base64.h>
#include <boost/range/iterator_range.hpp>

namespace yplatform {

namespace detail {
template <typename InputIterator>
struct base64_traits
{
    typedef iterators::base64_from_binary<InputIterator> base64_t;
    typedef iterators::base64_urlsafe_from_binary<InputIterator> base64_urlsafe_t;
    typedef iterators::binary_from_base64<InputIterator> binary_t;
    typedef iterators::binary_from_base64_urlsafe<InputIterator> binary_urlsafe_t;
};
}

template <typename Iterator>
typename detail::base64_traits<Iterator>::base64_t base64_encode_iterator(Iterator const& iter)
{
    return typename detail::base64_traits<Iterator>::base64_t(iter);
}

template <typename Iterator>
typename detail::base64_traits<Iterator>::base64_urlsafe_t base64_urlsafe_encode_iterator(
    Iterator const& iter)
{
    return typename detail::base64_traits<Iterator>::base64_urlsafe_t(iter);
}

template <typename InputIterator>
boost::iterator_range<typename detail::base64_traits<InputIterator>::base64_t> base64_encode(
    boost::iterator_range<InputIterator> const& rng)
{
    typedef typename detail::base64_traits<InputIterator>::base64_t iter_t;
    typedef boost::iterator_range<iter_t> cvt_t;
    return cvt_t(iter_t(rng.begin(), rng.end()), iter_t(rng.end(), rng.end()));
}

template <typename Range>
boost::iterator_range<
    typename detail::base64_traits<typename boost::range_iterator<Range>::type>::base64_t>
base64_encode(Range const& rng)
{
    typedef typename boost::range_iterator<Range>::type input_iterator;
    typedef typename detail::base64_traits<input_iterator>::base64_t iter_t;
    typedef boost::iterator_range<iter_t> cvt_t;
    return cvt_t(iter_t(rng.begin(), rng.end()), iter_t(rng.end(), rng.end()));
}

template <typename InputIterator>
boost::iterator_range<typename detail::base64_traits<InputIterator>::base64_t> base64_encode(
    InputIterator const& start,
    InputIterator const& finish)
{
    typedef typename detail::base64_traits<InputIterator>::base64_t iter_t;
    typedef boost::iterator_range<iter_t> cvt_t;
    return cvt_t(iter_t(start, finish), iter_t(finish, finish));
}

template <typename Range>
std::string base64_encode_str(const Range& rng)
{
    std::string encoded;
    encoded += base64_encode(rng.begin(), rng.end());
    return encoded;
}

template <typename InputIterator>
boost::iterator_range<typename detail::base64_traits<InputIterator>::base64_urlsafe_t>
base64_urlsafe_encode(boost::iterator_range<InputIterator> const& rng)
{
    typedef typename detail::base64_traits<InputIterator>::base64_urlsafe_t iter_t;
    typedef boost::iterator_range<iter_t> cvt_t;
    return cvt_t(iter_t(rng.begin(), rng.end()), iter_t(rng.end(), rng.end()));
}

template <typename Range>
boost::iterator_range<
    typename detail::base64_traits<typename boost::range_iterator<Range>::type>::base64_urlsafe_t>
base64_urlsafe_encode(Range const& rng)
{
    typedef typename boost::range_iterator<Range>::type input_iterator;
    typedef typename detail::base64_traits<input_iterator>::base64_urlsafe_t iter_t;
    typedef boost::iterator_range<iter_t> cvt_t;
    return cvt_t(iter_t(rng.begin(), rng.end()), iter_t(rng.end(), rng.end()));
}

template <typename InputIterator>
boost::iterator_range<typename detail::base64_traits<InputIterator>::base64_urlsafe_t>
base64_urlsafe_encode(InputIterator const& start, InputIterator const& finish)
{
    typedef typename detail::base64_traits<InputIterator>::base64_urlsafe_t iter_t;
    typedef boost::iterator_range<iter_t> cvt_t;
    return cvt_t(iter_t(start, finish), iter_t(finish, finish));
}

template <typename Range>
std::string base64_urlsafe_encode_str(const Range& rng)
{
    std::string encoded;
    encoded += base64_urlsafe_encode(rng.begin(), rng.end());
    return encoded;
}

template <typename Iterator>
typename detail::base64_traits<Iterator>::binary_t base64_decode_iterator(
    Iterator const& first,
    Iterator const& last = Iterator())
{
    return typename detail::base64_traits<Iterator>::binary_t(first, last);
}

template <typename Iterator>
typename detail::base64_traits<Iterator>::binary_urlsafe_t base64_urlsafe_decode_iterator(
    Iterator const& first,
    Iterator const& last = Iterator())
{
    return typename detail::base64_traits<Iterator>::binary_urlsafe_t(first, last);
}

template <typename InputIterator>
boost::iterator_range<typename detail::base64_traits<InputIterator>::binary_t> base64_decode(
    boost::iterator_range<InputIterator> const& rng)
{
    typedef typename detail::base64_traits<InputIterator>::binary_t iter_t;
    typedef boost::iterator_range<iter_t> cvt_t;
    return cvt_t(rng.begin(), rng.end());
}

template <typename Range>
boost::iterator_range<
    typename detail::base64_traits<typename boost::range_iterator<Range>::type>::binary_t>
base64_decode(Range& rng)
{
    typedef typename boost::range_iterator<Range>::type input_iterator;
    typedef typename detail::base64_traits<input_iterator>::binary_t iter_t;
    typedef boost::iterator_range<iter_t> cvt_t;
    return cvt_t(iter_t(rng.begin(), rng.end()), iter_t(rng.end(), rng.end()));
}

template <typename InputIterator>
boost::iterator_range<typename detail::base64_traits<InputIterator>::binary_t> base64_decode(
    InputIterator const& first,
    InputIterator const& last)
{
    typedef typename detail::base64_traits<InputIterator>::binary_t iter_t;
    typedef boost::iterator_range<iter_t> cvt_t;
    return cvt_t(iter_t(first, last), iter_t(last, last));
}

template <typename Range>
std::string base64_decode_str(const Range& rng)
{
    std::string decoded;
    decoded += base64_decode(rng.begin(), rng.end());
    return decoded;
}

template <typename InputIterator>
boost::iterator_range<typename detail::base64_traits<InputIterator>::binary_urlsafe_t>
base64_urlsafe_decode(boost::iterator_range<InputIterator> const& rng)
{
    typedef typename detail::base64_traits<InputIterator>::binary_urlsafe_t iter_t;
    typedef boost::iterator_range<iter_t> cvt_t;
    return cvt_t(rng.begin(), rng.end());
}

template <typename Range>
boost::iterator_range<
    typename detail::base64_traits<typename boost::range_iterator<Range>::type>::binary_urlsafe_t>
base64_urlsafe_decode(Range& rng)
{
    typedef typename boost::range_iterator<Range>::type input_iterator;
    typedef typename detail::base64_traits<input_iterator>::binary_urlsafe_t iter_t;
    typedef boost::iterator_range<iter_t> cvt_t;
    return cvt_t(iter_t(rng.begin(), rng.end()), iter_t(rng.end(), rng.end()));
}

template <typename InputIterator>
boost::iterator_range<typename detail::base64_traits<InputIterator>::binary_urlsafe_t>
base64_urlsafe_decode(InputIterator const& first, InputIterator const& last)
{
    typedef typename detail::base64_traits<InputIterator>::binary_urlsafe_t iter_t;
    typedef boost::iterator_range<iter_t> cvt_t;
    return cvt_t(iter_t(first, last), iter_t(last, last));
}

template <typename Range>
std::string base64_urlsafe_decode_str(const Range& rng)
{
    std::string decoded;
    decoded += base64_urlsafe_decode(rng.begin(), rng.end());
    return decoded;
}

class decoder_impl
{
public:
    void init()
    {
        step_ = step_a;
        plainchar_ = 0;
    }

    int decode_value(char in) const
    {
        static const char decoding[] = { 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60,
                                         61, -1, -1, -1, -2, -1, -1, -1, 0,  1,  2,  3,  4,  5,
                                         6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
                                         20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27,
                                         28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
                                         42, 43, 44, 45, 46, 47, 48, 49, 50, 51 };
        static const char decoding_size = sizeof(decoding);
        int sym = in - 43;
        if (sym < 0 || sym >= decoding_size) return -1;
        return decoding[sym];
    }

protected:
    enum decodestep
    {
        step_a,
        step_b,
        step_c,
        step_d
    } step_;
    char plainchar_;
};

class decoder : public decoder_impl
{
public:
    inline decoder()
    {
        init();
    }

    inline int decode(char ch) const
    {
        return decode_value(ch);
    }

    template <typename IteratorIn, typename IteratorOut>
    IteratorOut decode(
        IteratorIn& fi,
        IteratorIn const& li,
        IteratorOut& fo,
        IteratorOut const& lo);

    template <typename IteratorIn, typename IteratorOut>
    IteratorOut decode(IteratorIn fi, IteratorIn const& li, IteratorOut fo);
};

template <typename IteratorIn, typename IteratorOut>
IteratorOut decoder::decode(
    IteratorIn& in_char,
    IteratorIn const& in_last,
    IteratorOut& out_char,
    IteratorOut const& out_last)
{
    // typedef typename boost::iterator_value<IteratorIn>::type in_type;
    // typedef typename boost::iterator_value<IteratorOut>::type out_type;

    char fragment;

    switch (step_)
    {
        for (;;)
        {
        case step_a:
            do
            {
                if (in_char == in_last) return out_char;

                fragment = static_cast<char>(decode_value(*in_char++));
            } while (fragment < 0);

            plainchar_ = (fragment & 0x03f) << 2;

        case step_b:
            do
            {
                if (in_char == in_last) return out_char;

                fragment = static_cast<char>(decode_value(*in_char++));
            } while (fragment < 0);

            plainchar_ |= (fragment & 0x030) >> 4;
            *out_char++ = plainchar_;
            if (out_char == out_last) return out_char;
            plainchar_ = (fragment & 0x00f) << 4;

        case step_c:
            do
            {
                if (in_char == in_last) return out_char;

                fragment = static_cast<char>(decode_value(*in_char++));
            } while (fragment < 0);

            plainchar_ |= (fragment & 0x03c) >> 2;
            *out_char++ = plainchar_;
            if (out_char == out_last) return out_char;
            plainchar_ = (fragment & 0x003) << 6;

        case step_d:
            do
            {
                if (in_char == in_last) return out_char;

                fragment = static_cast<char>(decode_value(*in_char++));
            } while (fragment < 0);
            plainchar_ |= (fragment & 0x03f);
            *out_char++ = plainchar_;
            if (out_char == out_last) return out_char;
        } // for
    }     // switch
}

template <typename IteratorIn, typename IteratorOut>
IteratorOut decoder::decode(IteratorIn in_char, IteratorIn const& in_last, IteratorOut out_char)
{
    // typedef typename boost::iterator_value<IteratorIn>::type in_type;
    // typedef typename boost::iterator_value<IteratorOut>::type out_type;

    char fragment;

    switch (step_)
    {
        for (;;)
        {
        case step_a:
            do
            {
                if (in_char == in_last) return out_char;

                fragment = static_cast<char>(decode_value(*in_char++));
            } while (fragment < 0);

            plainchar_ = (fragment & 0x03f) << 2;

        case step_b:
            do
            {
                if (in_char == in_last) return out_char;

                fragment = static_cast<char>(decode_value(*in_char++));
            } while (fragment < 0);

            plainchar_ |= (fragment & 0x030) >> 4;
            *out_char++ = plainchar_;
            plainchar_ = (fragment & 0x00f) << 4;

        case step_c:
            do
            {
                if (in_char == in_last) return out_char;

                fragment = static_cast<char>(decode_value(*in_char++));
            } while (fragment < 0);

            plainchar_ |= (fragment & 0x03c) >> 2;
            *out_char++ = plainchar_;
            plainchar_ = (fragment & 0x003) << 6;

        case step_d:
            do
            {
                if (in_char == in_last) return out_char;

                fragment = static_cast<char>(decode_value(*in_char++));
            } while (fragment < 0);
            plainchar_ |= (fragment & 0x03f);
            *out_char++ = plainchar_;
        } // for
    }     // switch

    // really can never be here
    return out_char;
}

}
