#pragma once

#include <yplatform/range.h>

namespace yplatform { namespace iterators {
template <
    typename Base,
    typename CharType = BOOST_DEDUCED_TYPENAME boost::iterator_value<Base>::type>
class binary_from_quoted_printable
    : public boost::iterator_adaptor<
          binary_from_quoted_printable<Base, CharType>,
          Base,
          CharType,
          boost::single_pass_traversal_tag,
          CharType>
{
    friend class boost::iterator_core_access;
    typedef boost::iterator_adaptor<
        binary_from_quoted_printable<Base, CharType>,
        Base,
        CharType,
        boost::single_pass_traversal_tag,
        CharType>
        super_t;

    typedef binary_from_quoted_printable<Base, CharType> this_t;
    typedef BOOST_DEDUCED_TYPENAME boost::iterator_value<Base>::type base_value_type;

    CharType dereference() const
    {
        if (m_special) return m_special_char;
        else
            return *this->base_reference();
    }

    bool equal(this_t const& rhs) const
    {
        return this->base_reference() == rhs.base_reference();
    }

    CharType char_2_hex(CharType symb)
    {
        return ((symb >= '0' && symb <= '9') ? symb - '0' : 10 + toupper(symb) - 'A');
    }

    void increment()
    {
        ++this->base_reference();
        load_char();
    }

    void load_char()
    {
        m_special = false;
        if (this->base_reference() == last_ || *this->base_reference() != '=') return;

        CharType first = *(++this->base_reference());
        if (this->base_reference() == last_) return;
        CharType second = *(++this->base_reference());
        if (second == '\n')
        {
            increment();
            return;
        }
        m_special = true;
        m_special_char = 0x10 * char_2_hex(first) + char_2_hex(second);
    }

    CharType m_special_char;
    bool m_special;
    Base last_;

public:
    binary_from_quoted_printable(Base const& start, Base const& end)
        : super_t(start), m_special(false), last_(end)
    {
        load_char();
    }

    template <typename T>
    binary_from_quoted_printable(T const& start, T const& end)
        : super_t(static_cast<Base>(start)), m_special(false), last_(static_cast<Base>(end))
    {
        load_char();
    }
};
}}
