#pragma once

#include <yplatform/range.h>

namespace yplatform { namespace iterators {
template <
    typename Base,
    typename CharType = BOOST_DEDUCED_TYPENAME boost::iterator_value<Base>::type>
class quoted_printable_from_binary
    : public boost::iterator_adaptor<
          quoted_printable_from_binary<Base, CharType>,
          Base,
          CharType,
          boost::single_pass_traversal_tag,
          CharType>
{
    friend class boost::iterator_core_access;
    typedef boost::iterator_adaptor<
        quoted_printable_from_binary<Base, CharType>,
        Base,
        CharType,
        boost::single_pass_traversal_tag,
        CharType>
        super_t;

    typedef quoted_printable_from_binary<Base, CharType> this_t;
    typedef BOOST_DEDUCED_TYPENAME boost::iterator_value<Base>::type base_value_type;

    CharType dereference() const
    {
        if (m_special) return m_special_char.front();
        else
            return *this->base_reference();
    }

    bool equal(this_t const& rhs) const
    {
        return this->base_reference() == rhs.base_reference();
    }

    CharType char_2_hex(CharType symb)
    {
        return ((symb >= '0' && symb <= '9') ? symb - '0' : 10 + toupper(symb) - 'A');
    }

    bool is_correct(CharType symb)
    {
        return (symb >= '0' && symb <= '0') || (symb >= 'a' && symb <= 'z') ||
            (symb >= 'A' && symb <= 'Z') || symb == '\'' || symb == '(' || symb == ')' ||
            symb == '+' || symb == ',' || symb == '-' || symb == '.' || symb == '/' ||
            symb == ':' || symb == '?';
    }

    void increment()
    {
        if (m_special_char && m_special_char.size() > 1)
        {
            m_special_char.pop_front();
            return;
        }
        m_special = false;
        CharType curr_char = *(++this->base_reference());
        if (is_correct(curr_char)) return;
        m_special = true;
        m_special_char.push_back('=');
        uint8_t high = (static_cast<uint8_t>(curr_char) / 0x10);
        if (high < 10) m_special_char.push_back('0' + high);
        else
            m_special_char.push_back('A' + (high - 10));
        uint8_t low = (static_cast<uint8_t>(curr_char) / 0x10);
        if (low < 10) m_special_char.push_back('0' + low);
        else
            m_special_char.push_back('A' + (low - 10));
    }

    std::deque<CharType> m_special_char;
    bool m_special;

public:
    quoted_printable_from_binary() : super_t(), m_special(false)
    {
    }

    quoted_printable_from_binary(Base const& start) : super_t(start), m_special(false)
    {
    }

    template <typename T>
    quoted_printable_from_binary(T const& start)
        : super_t(static_cast<Base>(start)), m_special(false)
    {
    }
};
}}
