#pragma once
#include <boost/algorithm/string.hpp>
#include <boost/iterator/iterator_adaptor.hpp>
#include <boost/iterator/iterator_categories.hpp>

#include <boost/type_traits/is_class.hpp>
#include <boost/static_assert.hpp>

namespace yplatform {

// skips \ but leave next char intact
template <class Iterator>
class quoted_string_iterator;

namespace detail {

template <class Iterator>
struct quoted_string_iterator_base
{
    typedef boost::iterator_adaptor<
        quoted_string_iterator<Iterator>,
        Iterator,
        boost::use_default,
        typename boost::mpl::if_<
            boost::is_convertible<
                typename boost::iterator_traversal<Iterator>::type,
                boost::random_access_traversal_tag>,
            boost::bidirectional_traversal_tag,
            boost::use_default>::type>
        type;
};

}

template <typename Iterator>
class quoted_string_iterator : public detail::quoted_string_iterator_base<Iterator>::type
{
    typedef typename detail::quoted_string_iterator_base<Iterator>::type super_t;
    friend class boost::iterator_core_access;

    bool on_;
    Iterator end_;

public:
    quoted_string_iterator(bool on = true) : on_(on)
    {
    }

    quoted_string_iterator(Iterator x, bool on = true, Iterator __end = Iterator())
        : super_t(x), on_(on), end_(__end)
    {
        if (on_) skip_quote();
    }

    Iterator end() const
    {
        return end_;
    }

    template <class OtherIterator>
    quoted_string_iterator(
        quoted_string_iterator<OtherIterator> const& t,
        typename boost::enable_if_convertible<OtherIterator, Iterator>::type* = 0)
        : super_t(t.base()), end_(t.end())
    {
    }

private:
    void skip_quote()
    {
        if (this->base() != this->end_ && *this->base() == '\\')
        {
            Iterator save = this->base_reference()++;
            if (this->base() == this->end_) this->base_reference() = save;
        }
    }

    void increment()
    {
        ++(this->base_reference());
        if (on_) skip_quote();
    }

    void decrement()
    {
        --(this->base_reference());
        if (on_ && *this->base() == '\\') --(this->base_reference());
    }
};

}
