#pragma once

#include <boost/iterator/iterator_adaptor.hpp>
#include <iostream>

namespace yplatform { namespace iterators {

namespace detail {

struct is_nl
{
    template <typename CharT>
    inline bool operator()(CharT const& ch)
    {
        return ch == '\n' || ch == '\r';
    }
};

struct is_ws
{
    template <typename CharT>
    inline bool operator()(CharT const& ch)
    {
        return ch == ' ' || ch == '\t';
    }
};

}

template <typename _BaseIterator, typename _IsNL = detail::is_nl, typename _IsWS = detail::is_ws>
class remove_nl
    : public boost::iterator_adaptor<remove_nl<_BaseIterator, _IsNL, _IsWS>, _BaseIterator>
{
private:
    struct enabler
    {
    };

    typedef _BaseIterator base_iterator_type;
    typedef _IsNL is_nl_type;
    typedef _IsWS is_ws_type;

public:
    explicit inline remove_nl(
        base_iterator_type first,
        base_iterator_type last = base_iterator_type(),
        is_nl_type is_nl = is_nl_type(),
        is_ws_type is_ws = is_ws_type())
        : remove_nl::iterator_adaptor_(first), last_(last), is_nl_(is_nl), is_ws_(is_ws)
    {
        find_non_ws();
    }

private:
    friend class boost::iterator_core_access;

    void find_non_ws()
    {
#if 0
    if (this->base_reference () != last_)
    std::cout << "checking " << *this->base_reference () << "\n";
#endif
        while (this->base_reference() != last_ && is_nl_(*this->base_reference()))
        {
            do
                ++this->base_reference();
            while (this->base_reference() != last_ && is_ws_(*this->base_reference()));
        }
    }

    inline void increment()
    {
        ++this->base_reference();
        find_non_ws();
    }

    // template <class OtherDerived, class N, class W>
    typename remove_nl::difference_type distance_to(
        remove_nl /*<OtherDerived, N, V>*/ const& y) const
    {
        short sign = -1;

        remove_nl tmp1(y);
        remove_nl tmp2(*this);

        if (tmp1.base_reference() == last_)
        {
            std::swap(tmp1, tmp2);
            sign = 1;
        }

        typename remove_nl::difference_type dist = 0;
        for (; tmp1 != tmp2; ++dist, ++tmp1)
            ;
        return dist * sign;
    }

    template <class OtherDerived, class N, class W>
    inline bool equal(remove_nl<OtherDerived, N, W> const& y) const
    {
        return this->base_reference() == y.base_reference();
    }

private:
    base_iterator_type last_;
    is_nl_type is_nl_;
    is_ws_type is_ws_;
};

}}
