#pragma once

#include <yplatform/range.h>
#include <yplatform/encoding/iterators/qp_from_binary.h>
#include <yplatform/encoding/iterators/binary_from_qp.h>
#include <boost/range/iterator_range.hpp>

namespace yplatform {

template <typename InputIterator>
boost::iterator_range<iterators::quoted_printable_from_binary<InputIterator>>
quoted_printable_encode(boost::iterator_range<InputIterator> const& rng)
{
    typedef iterators::quoted_printable_from_binary<InputIterator> iter_t;
    typedef boost::iterator_range<iter_t> cvt_t;
    return cvt_t(rng.begin(), rng.end());
}

template <typename Range>
boost::iterator_range<
    iterators::quoted_printable_from_binary<typename boost::range_iterator<Range>::type>>
quoted_printable_encode(Range const& rng)
{
    typedef typename boost::range_iterator<Range>::type input_iterator;
    typedef iterators::quoted_printable_from_binary<input_iterator> iter_t;
    typedef boost::iterator_range<iter_t> cvt_t;
    return cvt_t(rng.begin(), rng.end());
}

template <typename InputIterator>
boost::iterator_range<iterators::quoted_printable_from_binary<InputIterator>>
quoted_printable_encode(InputIterator const& start, InputIterator const& finish)
{
    typedef iterators::quoted_printable_from_binary<InputIterator> iter_t;
    typedef boost::iterator_range<iter_t> cvt_t;
    return cvt_t(start, finish);
}

template <typename InputIterator>
boost::iterator_range<iterators::binary_from_quoted_printable<InputIterator>>
quoted_printable_decode(boost::iterator_range<InputIterator> const& rng)
{
    typedef iterators::binary_from_quoted_printable<InputIterator> iter_t;
    typedef boost::iterator_range<iter_t> cvt_t;
    return cvt_t(iter_t(rng.begin(), rng.end()), iter_t(rng.end(), rng.end()));
}

template <typename Range>
boost::iterator_range<
    iterators::binary_from_quoted_printable<typename boost::range_iterator<Range>::type>>
quoted_printable_decode(Range& rng)
{
    typedef typename boost::range_iterator<Range>::type input_iterator;
    typedef iterators::binary_from_quoted_printable<input_iterator> iter_t;
    typedef boost::iterator_range<iter_t> cvt_t;
    return cvt_t(iter_t(rng.begin(), rng.end()), iter_t(rng.end(), rng.end()));
}

template <typename InputIterator>
boost::iterator_range<iterators::binary_from_quoted_printable<InputIterator>>
quoted_printable_decode(InputIterator const& first, InputIterator const& last)
{
    typedef iterators::binary_from_quoted_printable<InputIterator> iter_t;
    typedef boost::iterator_range<iter_t> cvt_t;
    return cvt_t(iter_t(first, last), iter_t(last, last));
}

}
