#pragma once

#include <yplatform/range.h>
#include <yplatform/encoding/iterators/urlenc_from_binary.h>
#include <yplatform/encoding/iterators/binary_from_urlenc.h>
#include <boost/range/iterator_range.hpp>

namespace yplatform {

template <typename Iterator>
iterators::urlenc_from_binary<Iterator> url_encode_iterator(Iterator const& iter)
{
    return iterators::urlenc_from_binary<Iterator>(iter);
}

template <typename Iterator>
iterators::binary_from_urlenc<Iterator> url_decode_iterator(Iterator const& iter)
{
    return iterators::binary_from_urlenc<Iterator>(iter);
}

template <typename Result, typename Range>
struct urlenc_helper
{
    typedef Result encode_return_type;
    typedef Result decode_return_type;

    static encode_return_type encode(Range const& rng)
    {
        auto iters = urlenc_helper<void, Range>::encode(rng);
        return { iters.begin(), iters.end() };
    }

    static decode_return_type decode(Range const& rng)
    {
        auto iters = urlenc_helper<void, Range>::decode(rng);
        return { iters.begin(), iters.end() };
    }
};

template <typename Range>
struct urlenc_helper<void, Range>
{
    typedef iterators::urlenc_from_binary<typename boost::range_iterator<Range const>::type>
        encode_iter_t;

    typedef boost::iterator_range<encode_iter_t> encode_return_type;

    static encode_return_type encode(Range const& rng)
    {
        return boost::iterator_range<encode_iter_t>(
            encode_iter_t(rng.begin()), encode_iter_t(rng.end()));
    }

    typedef iterators::binary_from_urlenc<typename boost::range_iterator<Range const>::type>
        decode_iter_t;

    typedef boost::iterator_range<decode_iter_t> decode_return_type;

    static decode_return_type decode(Range const& rng)
    {
        return boost::iterator_range<decode_iter_t>(
            decode_iter_t(rng.begin(), rng.end()), decode_iter_t(rng.end(), rng.end()));
    }
};

template <typename Result = void, typename Range = std::string>
typename urlenc_helper<Result, Range>::encode_return_type url_encode(Range const& rng)
{
    return urlenc_helper<Result, Range>::encode(rng);
}

template <typename Result = void, typename Range = std::string>
typename urlenc_helper<Result, Range>::decode_return_type url_decode(Range const& rng)
{
    return urlenc_helper<Result, Range>::decode(rng);
}

}
