#pragma once

#include <openssl/md5.h>
#include <stdio.h>
#include <stdlib.h>
#include <string>

namespace yplatform {

namespace detail {

inline void MD5_Update(MD5_CTX* ctx, const std::string& str)
{
    MD5_Update(ctx, str.data(), str.size());
}

inline void MD5_Update(MD5_CTX* ctx, const char* c_str)
{
    MD5_Update(ctx, c_str, strlen(c_str));
}

template <typename Arg, typename... Args>
inline void MD5_Update(MD5_CTX* ctx, Arg arg, const Args&... args)
{
    MD5_Update(ctx, arg);
    MD5_Update(ctx, args...);
}
}

template <typename... Args>
inline std::string md5(const Args&... args)
{
    int i;
    MD5_CTX md5handler;
    unsigned char md5digest[MD5_DIGEST_LENGTH];

    MD5_Init(&md5handler);
    detail::MD5_Update(&md5handler, args...);
    MD5_Final(md5digest, &md5handler);

    std::string result;
    result.resize(MD5_DIGEST_LENGTH * 2 + 1);
    for (i = 0; i < MD5_DIGEST_LENGTH; i++)
    {
        snprintf(&result[i * 2], 3, "%02x", md5digest[i]);
    };
    result.resize(MD5_DIGEST_LENGTH * 2); // trim extra '\0'
    return result;
}

}
