#pragma once

#include <yplatform/log/settings.h>
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wold-style-cast"
#include <spdlog/spdlog.h>
#pragma GCC diagnostic pop
#include <boost/range/adaptor/transformed.hpp>

namespace yplatform { namespace log { namespace detail { namespace spd {

spdlog::level::level_enum level_from_str(const std::string& name);

struct box
{
    std::shared_ptr<spdlog::logger> logger;
    std::vector<spdlog::sink_ptr> sinks;
};

using boxes = std::vector<box>;

bool bool_from_alpha_param(const boost::optional<std::string>& param, bool default_value);
spdlog::sink_ptr make_sink(const log::sink_settings& config, bool async);
spdlog::async_overflow_policy make_overflow_policy(const std::string& value);

namespace detail {
// should not return zero (an spdlog queue implementation detail)
inline uint64_t pow2roundup(uint64_t x)
{
    if (x > (1ull << 63))
    {
        return 1ull << 63;
    }
    int pow = 0;
    while (x >>= 1)
        ++pow;
    return 1ull << (pow + 1);
}
}

template <class Sinks>
std::shared_ptr<spdlog::logger> make_async_logger(
    const std::string& name,
    const Sinks& sinks,
    const log::log_settings& config)
{
    const auto queue_size = detail::pow2roundup(config.queue_size);
    const auto overflow_policy = make_overflow_policy(config.overflow_policy);
    return std::make_shared<spdlog::async_logger>(
        name, std::begin(sinks), std::end(sinks), queue_size, overflow_policy);
}

template <class Sinks>
std::shared_ptr<spdlog::logger> make_sync_logger(const std::string& name, const Sinks& sinks)
{
    return std::make_shared<spdlog::logger>(name, std::begin(sinks), std::end(sinks));
}

box make_box(const std::string& name, const log::log_settings& config);
boxes make(const log::settings& config);

} // namespace spd
} // namespace detail
} // namespace log
} // namespace yplatform
