#pragma once

#include <yplatform/log/logger.h>
#include <yplatform/log/service.h>

namespace yplatform { namespace log {
namespace detail {

template <typename T = log::source>
inline T find(detail::service& service, const std::string& name, bool fallback_to_global = true)
{
    if (!fallback_to_global && !service.has_logger(name))
    {
        throw std::invalid_argument(fmt::format("logger '{}' is not found", name));
    }

    return T(service, name);
}

} // namespace detail

template <typename T = log::source>
inline T find(const std::string& name, bool fallback_to_global = true)
{
    if (!log::detail::global_service::instance().inited())
        throw std::runtime_error("global log service is not inited");

    return detail::find<T>(YGLOBAL_LOG_SERVICE, name, fallback_to_global);
}

template <typename T = log::source>
inline T find(boost::asio::io_service& io, const std::string& name, bool fallback_to_global = true)
{
    return detail::find<T>(log::get_service_impl(io), name, fallback_to_global);
}

} // namespace log
} // namespace yplatform
