#pragma once

#include <string>

namespace yplatform { namespace log {

class has_log_prefix
{
public:
    has_log_prefix(const std::string& prefix = std::string())
    {
        if (!prefix.empty())
        {
            set_log_prefix(prefix);
        }
    }

    has_log_prefix(const has_log_prefix& other)
    {
        log_prefix_ = other.log_prefix_;
    }

    has_log_prefix& operator=(const has_log_prefix& other)
    {
        if (this != &other)
        {
            log_prefix_ = other.log_prefix_;
        }
        return *this;
    }

    const std::string& get_log_prefix() const
    {
        return log_prefix_;
    }

    void set_log_prefix(const std::string& log_prefix)
    {
        log_prefix_.reserve(log_prefix.size() + 1);
        log_prefix_ = log_prefix;
        log_prefix_ += ' ';
    }

    void append_log_prefix(const std::string& extra)
    {
        log_prefix_.reserve(log_prefix_.size() + extra.size() + 1);
        log_prefix_ += extra;
        log_prefix_ += ' ';
    }

private:
    std::string log_prefix_;
};

} // namespace log
} // namespace yplatform
