#pragma once

#include <boost/chrono/system_clocks.hpp>
#include <sstream>
#include <string>
#include <vector>

// TODO remove after merge of elsid@'s pull request
namespace yplatform { namespace time_traits {

using clock = boost::chrono::steady_clock;
using timer = boost::asio::basic_waitable_timer<clock>;
using timer_ptr = std::shared_ptr<timer>;
using time_point = clock::time_point;
using duration = clock::duration;
using boost::chrono::milliseconds;
using float_seconds = boost::chrono::duration<double>;

} // namespace time_traits
} // namespace yplatform

namespace yplatform { namespace log {

class debug_logger
{
public:
    debug_logger()
    {
        data_.reserve(1024);
    }

    typedef time_traits::time_point time_point;
    typedef time_traits::duration time_duration;

    time_point get_start_time() const
    {
        return start_time_;
    }

    void reset_start_time()
    {
        start_time_ = time_traits::clock::now();
    }

    void add(const std::string& line)
    {
        data_.append(line);
    }

    std::string flush()
    {
        std::string result;
        result.swap(data_);
        return result;
    }

private:
    std::string data_;
    time_point start_time_;
};

struct debug_streamer
{
    debug_streamer(debug_logger& logger) : logger_(logger)
    {
        time_traits::float_seconds diff = time_traits::clock::now() - logger_.get_start_time();
        ss_ << " +" << std::fixed << std::setprecision(6) << diff.count() << " ";
    }

    ~debug_streamer()
    {
        logger_.add(std::move(ss_.str()));
    }

    template <typename T>
    debug_streamer& operator<<(const T& t)
    {
        ss_ << t;
        return *this;
    }

    debug_logger& logger_;
    std::stringstream ss_;
};

}}