#pragma once

#include <yplatform/log/detail/service.h>

#include <boost/asio.hpp>

namespace yplatform { namespace log {

class service : public boost::asio::io_service::service
{
public:
    static boost::asio::io_service::id id;

    service(boost::asio::io_service& io)
        : boost::asio::io_service::service(io), impl_(std::make_shared<detail::service>())
    {
    }

    void init(const log::settings& conf)
    {
        impl_ = std::make_shared<detail::service>(conf);
    }

    void init(std::shared_ptr<detail::service> impl)
    {
        impl_ = impl;
    }

    detail::service& get()
    {
        if (!impl_)
        {
            throw std::runtime_error("access to not inited log service");
        }
        return *impl_;
    }

private:
    std::shared_ptr<detail::service> impl_;
};

inline service& get_service(boost::asio::io_service& io)
{
    return boost::asio::use_service<log::service>(io);
}

inline detail::service& get_service_impl(boost::asio::io_service& io)
{
    return get_service(io).get();
}

template <typename... Args>
inline void init(boost::asio::io_service& io, Args&&... args)
{
    get_service(io).init(std::forward<Args>(args)...);
}

} // namespace log
} // namespace yplatform
