#pragma once

#include <yplatform/ptree.h>

#include <boost/optional.hpp>
#include <map>
#include <string>
#include <vector>

namespace yplatform { namespace log {

enum class sink_type
{
    stdout = 0,
    file,
    syslog,
    reference
};

struct sink_settings
{
    bool force_flush = false;
    std::string path;
    boost::optional<std::string> name;
    sink_type type = sink_type::stdout;
    std::string facility;
    std::string ident;
};

struct log_settings
{
    bool async = true;
    std::string level = "info";
    std::size_t queue_size = 1024;
    std::string overflow_policy = "discard_log_msg";
    std::string format = "[%Y-%b-%d %H:%M:%S.%f] %v";
    std::vector<sink_settings> sinks;
};

struct settings
{
    std::map<std::string, log_settings> logs;

    void parse_ptree(const ptree& data);
};

} // namespace log
} // namespace yplatform