#pragma once

#include <yplatform/log/reopenable.h>
#include <yplatform/log/typed_stream.h>
#include <spdlog/logger.h>

namespace yplatform { namespace log {

class spdlog_stream
{
public:
    template <class... Args>
    spdlog_stream(Args&&... args) : impl(std::forward<Args>(args)...)
    {
    }

    spdlog_stream(const spdlog_stream& other) = delete;
    spdlog_stream(spdlog_stream&& other) = default;

    template <class T>
    spdlog_stream& operator<<(T&& value)
    {
        impl << std::forward<T>(value);
        return *this;
    }

    inline operator bool() const
    {
        return impl.is_enabled();
    }

    void close()
    {
        const spdlog::details::line_logger moved(std::move(impl));
        (void)moved;
    }

private:
    spdlog::details::line_logger impl;
};

} // namespace log
} // namespace yplatform
