#pragma once

#include <yplatform/log/service.h>
#include <yplatform/log/typed_attributes.h>
#include <yplatform/log/typed_stream.h>
#include <iostream>
#include <set>
#include <string>
#include <map>
#include <utility> // std::pair, std::move

namespace yplatform { namespace log {
namespace typed {

class logger
{
public:
    using stream = log::detail::service::typed_stream;
    using impl_type = log::detail::service::typed_logger_impl;

    logger(log::service& service, const std::string& name) : service_(service.get())
    {
        service_.construct(impl_, name);
    }

    logger(log::detail::service& service, const std::string& name) : service_(service)
    {
        service_.construct(impl_, name);
    }

    logger(boost::asio::io_service& io, const std::string& name) : service_(get_service_impl(io))
    {
        service_.construct(impl_, name);
    }

    logger(const logger& other) : service_(other.service_), impl_(other.impl_)
    {
    }

    logger(logger&& other) : service_(other.service_), impl_(std::move(other.impl_))
    {
    }

    ~logger()
    {
        service_.destruct(impl_);
    }

    logger& operator=(const logger& other)
    {
        impl_ = other.impl_;
        return *this;
    }

    logger& operator=(logger&& other)
    {
        impl_ = std::move(other.impl_);
        return *this;
    }

    stream write(const severity_level level) const
    {
        return service_.write(impl_, level);
    }

    bool should_log(const severity_level level) const
    {
        return service_.should_log(impl_, level);
    }

private:
    log::detail::service& service_;
    impl_type impl_;
};

} // namespace typed

using tskv_logger = typed::logger;

} // namespace log
} // namespace yplatform
