#pragma once

#include <stdint.h>

#if defined(__linux__)
#if defined(__linux__)
#include <endian.h>
#else // __APPLE__
#include <machine/endian.h>
#endif
#ifndef htobe16
#include <byteswap.h>
#if __BYTE_ORDER == __LITTLE_ENDIAN
#define htobe16(x) bswap_16(x)
#define be16toh(x) bswap_16(x)
#define htobe32(x) bswap_32(x)
#define be32toh(x) bswap_32(x)
#define htobe64(x) bswap_64(x)
#define be64toh(x) bswap_64(x)
#else
#define htobe16(x) (x)
#define be16toh(x) (x)
#define htobe32(x) (x)
#define be32toh(x) (x)
#define htobe64(x) (x)
#define be64toh(x) (x)
#endif
#endif
#elif defined(__FreeBSD__) || defined(__NetBSD__)
#include <sys/endian.h>
#elif defined(__OpenBSD__)
#include <sys/types.h>
#define be16toh(x) betoh16(x)
#define be32toh(x) betoh32(x)
#define be64toh(x) betoh64(x)
#elif defined(__APPLE_CC__)

#if defined(__x86_64__) && defined(__APPLE__)

#include <libkern/OSByteOrder.h>

#define be64toh(x) (unsigned long long)OSSwapBigToHostInt64((uint64_t)x)
#define be32toh(x) (unsigned long)OSSwapBigToHostInt32((uint32_t)x)
#define be16toh(x) (unsigned short)OSSwapBigToHostInt16((uint16_t)x)
#define le64toh(x) (unsigned long long)OSSwapLittleToHostInt64((uint64_t)x)
#define le32toh(x) (unsigned long)OSSwapLittleToHostInt32((uint32_t)x)
#define le16toh(x) (unsigned short)OSSwapLittleToHostInt16((uint16_t)x)
#define htobe64(x) (unsigned long long)OSSwapHostToBigInt64((uint64_t)x)
#define htobe32(x) (unsigned long)OSSwapHostToBigInt32((uint32_t)x)
#define htobe16(x) (unsigned short)OSSwapHostToBigInt16((uint16_t)x)
#define htole64(x) (unsigned long long)OSSwapHostToLittleInt64((uint64_t)x)
#define htole32(x) (unsigned long)OSSwapHostToLittleInt32((uint32_t)x)
#define htole16(x) (unsigned short)OSSwapHostToLittleInt16((uint16_t)x)

#else

#include <architecture/byte_order.h>

#define be64toh(x) NXSwapBigLongLongToHost(x)
#define be32toh(x) NXSwapBigLongToHost(x)
#define be16toh(x) NXSwapBigShortToHost(x)
#define le64toh(x) NXSwapLittleLongLongToHost(x)
#define le32toh(x) NXSwapLittleLongToHost(x)
#define le16toh(x) NXSwapLittleShortToHost(x)
#define htobe64(x) NXSwapHostLongLongToBig(x)
#define htobe32(x) NXSwapHostLongToBig(x)
#define htobe16(x) NXSwapHostShortToBig(x)
#define htole64(x) NXSwapHostLongLongToLittle(x)
#define htole32(x) NXSwapHostLongToLittle(x)
#define htole16(x) NXSwapHostShortToLittle(x)

#endif

#endif

namespace yplatform { namespace net {

/* push/pop work with recent gcc version */
#if __GNUC__ > 4 || (__GNUC__ == 4 && __GNUC_MINOR__ > 4) || __clang__
#pragma GCC diagnostic push
#endif
#pragma GCC diagnostic ignored "-Wold-style-cast"

inline uint8_t host_2_network(uint8_t t)
{
    return t;
}

inline uint8_t network_2_host(uint8_t t)
{
    return t;
}

inline int8_t host_2_network(int8_t t)
{
    return t;
}

inline int8_t network_2_host(int8_t t)
{
    return t;
}

inline uint16_t host_2_network(uint16_t t)
{
    return htobe16(t);
}

inline uint16_t network_2_host(uint16_t t)
{
    return be16toh(t);
}

inline int16_t host_2_network(int16_t t)
{
    return (int16_t)htobe16(t);
}

inline int16_t network_2_host(int16_t t)
{
    return (int16_t)be16toh(t);
}

inline uint32_t host_2_network(uint32_t t)
{
    return htobe32(t);
}

inline uint32_t network_2_host(uint32_t t)
{
    return be32toh(t);
}

inline int32_t host_2_network(int32_t t)
{
    return (int32_t)htobe32(t);
}

inline int32_t network_2_host(int32_t t)
{
    return (int32_t)be32toh(t);
}

inline uint64_t host_2_network(uint64_t t)
{
    return htobe64(t);
}

inline uint64_t network_2_host(uint64_t t)
{
    return be64toh(t);
}

inline int64_t host_2_network(int64_t t)
{
    return (int64_t)htobe64(t);
}

inline int64_t network_2_host(int64_t t)
{
    return (int64_t)be64toh(t);
}

#if __GNUC__ > 4 || (__GNUC__ == 4 && __GNUC_MINOR__ > 4) || __clang__
#pragma GCC diagnostic pop
#else
#pragma GCC diagnostic error "-Wold-style-cast"
#endif

}}
