#pragma once

#include <yplatform/api.h>
#include <yplatform/net/net_service.h>

namespace yplatform { namespace net {

template <typename Session, typename StatsCont = service_stats>
class client : public net_service<Session, StatsCont>
{
public:
    typedef boost::shared_ptr<Session> session_ptr;
    typedef net_service<Session, StatsCont> base_t;

    client(const ::yplatform::reactor_ptr& reactor);

    session_ptr create_session(const typename Session::settings_t& settings)
    {
        auto session = boost::make_shared<Session>(this->get_io_pool().get_io_data(), settings);
        session->logger(this->logger());
        return session;
    }

    template <typename Allocator>
    session_ptr create_session(
        const typename Session::settings_t& settings,
        const Allocator& allocator)
    {
        auto session =
            boost::make_shared<Session>(this->get_io_pool().get_io_data(), settings, allocator);
        session->logger(this->logger());
        return session;
    }

    boost::asio::io_service* get_io()
    {
        return this->get_io_pool().get_io_data()->get_io();
    }

    template <typename CustomSession>
    boost::shared_ptr<CustomSession> create_session(
        const typename CustomSession::settings_t& settings)
    {
        auto session =
            boost::make_shared<CustomSession>(this->get_io_pool().get_io_data(), settings);
        session->logger(this->logger());
        return session;
    }
};

template <typename Session, typename StatsCont>
client<Session, StatsCont>::client(const ::yplatform::reactor_ptr& reactor) : base_t(reactor)
{
}

}}
