/* ---------------------------------------------------------------------------
** Asynchronous adaptor for dns libraries over boost asio.
**
** Author: ctor@yandex-team.ru
** -------------------------------------------------------------------------*/
#pragma once

#include <boost/asio.hpp>

namespace yplatform { namespace net { namespace dns {

template <typename Service>
class basic_resolver : public boost::asio::basic_io_object<Service>
{
public:
    explicit basic_resolver(boost::asio::io_service& io_service)
        : boost::asio::basic_io_object<Service>(io_service)
    {
    }

    typedef typename Service::iterator_a iterator_a;
    typedef typename Service::iterator_aaaa iterator_aaaa;
    typedef typename Service::iterator_ptr iterator_ptr;
    typedef typename Service::iterator_mx iterator_mx;
    typedef typename Service::iterator_txt iterator_txt;

    template <typename Handler>
    void async_resolve_a(const std::string& q, Handler handler)
    {
        this->get_service().async_resolve_a(this->get_implementation(), q, handler);
    }

    template <typename Handler>
    void async_resolve_aaaa(const std::string& q, Handler handler)
    {
        this->get_service().async_resolve_aaaa(this->get_implementation(), q, handler);
    }

    template <typename Handler>
    void async_resolve_ptr(const std::string& q, Handler handler)
    {
        this->get_service().async_resolve_ptr(this->get_implementation(), q, handler);
    }

    template <typename Handler>
    void async_resolve_mx(const std::string& q, Handler handler)
    {
        this->get_service().async_resolve_mx(this->get_implementation(), q, handler);
    }

    template <typename Handler>
    void async_resolve_txt(const std::string& q, Handler handler)
    {
        this->get_service().async_resolve_txt(this->get_implementation(), q, handler);
    }

    void cancel()
    {
        this->get_service().cancel(this->get_implementation());
    }
};

}}}
