#pragma once

#include <yplatform/time_traits.h>

#include <mutex>
#include <unordered_map>

namespace yplatform { namespace net { namespace dns { namespace detail {

template <typename dns_iterator>
class cache
{
    typedef std::unique_lock<std::mutex> unique_lock;

public:
    typedef dns_iterator iterator;

    dns_iterator update(
        const std::string& host,
        dns_iterator iter,
        const time_traits::duration& ttl)
    {
        if (iter != dns_iterator())
        {
            dns_cache_entry entry(iter, ttl);

            try
            {
                unique_lock lock(cache_mutex);
                cache[host] = entry;
            }
            catch (...)
            {
            }
        }
        return iter;
    }

    dns_iterator find(const std::string& host)
    {
        unique_lock lock(cache_mutex);

        auto found = cache.find(host);
        if (found != cache.end() && found->second.is_alive(time_traits::clock::now()))
        {
            return found->second.dns_result;
        }

        return dns_iterator();
    }

private:
    struct dns_cache_entry
    {
        dns_cache_entry() : live_until(time_traits::clock::now())
        {
        }

        dns_cache_entry(dns_iterator iter, const time_traits::duration& ttl)
            : dns_result(iter), live_until(time_traits::clock::now() + ttl)
        {
        }

        bool is_alive(const time_traits::time_point& now) const
        {
            return live_until > now;
        }

        dns_iterator dns_result;

    private:
        time_traits::time_point live_until;
    };

    std::unordered_map<std::string, dns_cache_entry> cache;
    mutable std::mutex cache_mutex;
};

}}}}