#pragma once

#include <yplatform/net/dns/detail/asio_resolver_service.h>
#include <yplatform/net/dns/detail/cache_resolver_service.h>
#include <yplatform/net/dns/resolver_settings.h>

namespace yplatform { namespace net { namespace dns {

// Cache lives in underlying service to decrease
// unnecessary handlers copying.
class resolver_service : public boost::asio::detail::service_base<resolver_service>
{
public:
    // TODO add implemetations to compare: adns, udns
    typedef detail::asio_resolver_service service_impl_type;
    typedef detail::cache_resolver_service<service_impl_type> cached_service_impl_type;

    // Internal data associated with a single resolver instance.
    typedef service_impl_type::resolver implementation_type;

    typedef service_impl_type::iterator_a iterator_a;
    typedef service_impl_type::iterator_aaaa iterator_aaaa;
    typedef service_impl_type::iterator_ptr iterator_ptr;
    typedef service_impl_type::iterator_mx iterator_mx;
    typedef service_impl_type::iterator_txt iterator_txt;

    resolver_service(boost::asio::io_service& io_service)
        : boost::asio::detail::service_base<resolver_service>(io_service)
    {
        impl = std::make_shared<cached_service_impl_type>(io_service);
    }

    void setup_service(const resolver_service_settings& settings)
    {
        impl->setup_service(settings);
    }

    void construct(implementation_type& resolver)
    {
        impl->construct(resolver);
    }

    void move_construct(implementation_type& resolver, implementation_type& other_resolver)
    {
        impl->move_construct(resolver, other_resolver);
    }

    void destroy(implementation_type& resolver)
    {
        impl->destroy(resolver);
    }

    // Resolve IPv4 addresses.
    template <typename Handler>
    void async_resolve_a(implementation_type& resolver, const std::string& q, Handler&& handler)
    {
        impl->async_resolve_a(resolver, q, std::forward<Handler>(handler));
    }

    // Resolve IPv6 addresses.
    template <typename Handler>
    void async_resolve_aaaa(implementation_type& resolver, const std::string& q, Handler&& handler)
    {
        impl->async_resolve_aaaa(resolver, q, std::forward<Handler>(handler));
    }

    // Back resolve.
    template <typename Handler>
    void async_resolve_ptr(implementation_type& resolver, const std::string& q, Handler&& handler)
    {
        impl->async_resolve_ptr(resolver, q, std::forward<Handler>(handler));
    }

    // Make MX (mail exchanger) records lookup.
    template <typename Handler>
    void async_resolve_mx(implementation_type& resolver, const std::string& q, Handler&& handler)
    {
        impl->async_resolve_mx(resolver, q, std::forward<Handler>(handler));
    }

    // Lookup TXT records.
    template <typename Handler>
    void async_resolve_txt(implementation_type& resolver, const std::string& q, Handler&& handler)
    {
        impl->async_resolve_txt(resolver, q, std::forward<Handler>(handler));
    }

    // cancel current resolve request.
    void cancel(implementation_type& resolver)
    {
        impl->cancel(resolver);
    }

protected:
    void shutdown_service()
    {
        impl->shutdown_service();
    }

private:
    // Service implementation is shared between final resolvers.
    std::shared_ptr<cached_service_impl_type> impl;
};

}}}
