#pragma once

#include <yplatform/ptree.h>
#include <yplatform/time_traits.h>

namespace yplatform { namespace net { namespace dns {

struct resolver_service_settings
{
    time_traits::duration cache_ttl = time_traits::duration::zero();

    bool use_cache()
    {
        return cache_ttl != time_traits::duration::zero();
    }

    void parse(const ptree& conf)
    {
        cache_ttl = conf.get<time_traits::duration>("cache_ttl", cache_ttl);
    }
};

}}}
