#pragma once
/* ---------------------------------------------------------------------------
** Asynchronous adaptor for dns libraries over boost asio.
**
** Author: ctor@yandex-team.ru
** -------------------------------------------------------------------------*/

#include <boost/asio/io_service.hpp>

namespace yplatform { namespace net { namespace dns {

template <typename Type>
class service_id : public boost::asio::io_service::id
{
};

// Stolen from boost::asio::detail::service_base to keep classes header-file only
template <typename Type>
class service_base : public boost::asio::io_service::service
{
public:
    static service_id<Type> id;

    service_base(boost::asio::io_service& io_service) : boost::asio::io_service::service(io_service)
    {
    }
};

template <typename Type>
service_id<Type> service_base<Type>::id;

}}}
