#pragma once

#include <yplatform/reactor.h>

namespace yplatform { namespace net {

namespace {
inline std::string get_reactor_name(const yplatform::ptree& data)
{
    // support old configs
    std::string reactor_name = data.get("reactor", "local");
    if (reactor_name == "") reactor_name = data.get("reactor.name", "local");
    return reactor_name;
}

inline ::yplatform::reactor_ptr register_local_reactor(
    const std::string& service_name,
    const yplatform::ptree& data)
{
    ::yplatform::reactor_cfg io_cfg;
    // if no reactor node pass root node to keep compatibility
    auto reactor_cfg = data.get_child_optional("reactor");
    io_cfg.load(reactor_cfg ? *reactor_cfg : data);
    return yplatform::global_reactor_set->add(service_name + "--local", io_cfg);
}

}

inline ::yplatform::reactor_ptr find_or_create_reactor(
    const yplatform::ptree& conf,
    const std::string& service_name)
{
    auto reactor_name = get_reactor_name(conf);
    return reactor_name == "local" ? register_local_reactor(service_name, conf) :
                                     yplatform::global_reactor_set->get(reactor_name);
}

}}
