#pragma once

#include <yplatform/net/types.h>
#include <utility>

namespace yplatform { namespace net {

namespace detail {
template <typename Handler>
struct protect_wrapper
{
    protect_wrapper(Handler&& h) : handler_(std::forward<Handler>(h))
    {
    }

    template <typename... Args>
    void operator()(Args&&... args)
    {
        handler_(std::forward<Args>(args)...);
    }

    template <typename... Args>
    void operator()(Args&&... args) const
    {
        handler_(std::forward<Args>(args)...);
    }

    typename std::decay<Handler>::type handler_;
};
}

template <typename T>
detail::protect_wrapper<T> protect_handler(T&& t)
{
    return detail::protect_wrapper<T>(std::forward<T>(t));
}

}}
