#pragma once

#include <yplatform/net/types.h>

namespace yplatform { namespace net {

template <typename ReadHook, typename Stats, typename Buffer, typename TimerPtr>
class read_handler
{
public:
    read_handler(ReadHook&& hook, Stats stats, Buffer buff, TimerPtr timer)
        : hook(static_cast<ReadHook&&>(hook)), stats(stats), buff(buff), timer(timer)
    {
    }

    read_handler(read_handler&& other)
        : hook(static_cast<ReadHook&&>(other.hook))
        , stats(other.stats)
        , buff(other.buff)
        , timer(other.timer)
    {
    }

    read_handler(const read_handler& other)
        : hook(other.hook), stats(other.stats), buff(other.buff), timer(other.timer)
    {
    }

    void operator()(const error_code& e, std::size_t bytes)
    {
        if (timer) timer->cancel();
        stats->update_io_counters(0, bytes);
        hook(e, bytes, buff);
    }

private:
    typename std::remove_reference<ReadHook>::type hook;
    Stats stats;
    Buffer buff;
    TimerPtr timer;
};

template <typename ReadHook, typename Stats, typename Buffer, typename TimerPtr>
inline read_handler<ReadHook, Stats, Buffer, TimerPtr> create_read_handler(
    ReadHook&& hook,
    const Stats& stats,
    Buffer buff,
    TimerPtr timer = TimerPtr())
{
    return read_handler<ReadHook, Stats, Buffer, TimerPtr>(
        static_cast<ReadHook&&>(hook), stats, buff, timer);
}

}}
