#pragma once

#include <yplatform/net/types.h>

namespace yplatform { namespace net {

template <typename TimerHook>
class timer_handler
{
public:
    timer_handler(TimerHook&& hook) : hook_(std::forward<TimerHook>(hook))
    {
    }

    void operator()(const error_code& e)
    {
        if (e != boost::asio::error::operation_aborted)
        {
            try
            {
                hook_();
            }
            catch (...)
            {
            }
        }
    }

private:
    typename std::decay<TimerHook>::type hook_;
};

template <typename TimerHook>
inline timer_handler<TimerHook> create_timer_handler(TimerHook&& hook)
{
    return timer_handler<TimerHook>(std::forward<TimerHook>(hook));
}

}}
