#pragma once

#include <yplatform/net/types.h>

namespace yplatform { namespace net {

template <typename SendHook, typename StatsPtr, typename TimerPtr>
class write_handler
{
public:
    write_handler(SendHook&& h, StatsPtr s, TimerPtr t)
        : hook(static_cast<SendHook&&>(h)), stats(s), timer(t)
    {
    }

    write_handler(write_handler&& other)
        : hook(static_cast<SendHook&&>(other.hook)), stats(other.stats), timer(other.timer)
    {
    }

    write_handler(const write_handler& other)
        : hook(other.hook), stats(other.stats), timer(other.timer)
    {
    }

    void operator()(const error_code& e, std::size_t bytes)
    {
        if (timer) timer->cancel();
        stats->update_io_counters(bytes, 0);
        hook(e, bytes);
    }

private:
    typename std::remove_reference<SendHook>::type hook;
    StatsPtr stats;
    TimerPtr timer;
};

template <typename SendHook, typename StatsPtr, typename Buffer, typename TimerPtr>
class write_handler_buff
{
public:
    write_handler_buff(SendHook&& h, StatsPtr s, const Buffer& b, TimerPtr t)
        : hook(static_cast<SendHook&&>(h)), stats(s), buff(b), timer(t)
    {
    }

    write_handler_buff(write_handler_buff&& other)
        : hook(static_cast<SendHook&&>(other.hook))
        , stats(other.stats)
        , buff(other.buff)
        , timer(other.timer)
    {
    }

    write_handler_buff(const write_handler_buff& other)
        : hook(other.hook), stats(other.stats), buff(other.buff), timer(other.timer)
    {
    }

    void operator()(const error_code& e, std::size_t bytes)
    {
        if (timer) timer->cancel();
        buff->consume(bytes);
        stats->update_io_counters(bytes, 0);
        hook(e, bytes);
    }

private:
    typename std::remove_reference<SendHook>::type hook;
    StatsPtr stats;
    Buffer buff;
    TimerPtr timer;
};

template <typename SendHook, typename StatsPtr, typename TimerPtr>
inline write_handler<SendHook, StatsPtr, TimerPtr> create_write_handler(
    SendHook&& hook,
    StatsPtr stats,
    TimerPtr timer = TimerPtr())
{
    return write_handler<SendHook, StatsPtr, TimerPtr>(static_cast<SendHook&&>(hook), stats, timer);
}

template <typename SendHook, typename StatsPtr, typename Buffer, typename TimerPtr>
inline write_handler_buff<SendHook, StatsPtr, Buffer, TimerPtr> create_write_handler_buff(
    SendHook&& hook,
    StatsPtr stats,
    const Buffer& buff,
    TimerPtr timer = TimerPtr())
{
    return write_handler_buff<SendHook, StatsPtr, Buffer, TimerPtr>(
        static_cast<SendHook&&>(hook), stats, buff, timer);
}

}}
