#pragma once

#include <netinet/tcp.h>

namespace yplatform { namespace net {

template <typename Socket, typename Settings>
void setup_keep_alive(Socket& socket, const Settings& settings)
{
    boost::system::error_code err;
    boost::asio::socket_base::keep_alive keep_alive(!settings.no_keep_alive);
    socket.set_option(keep_alive, err);

    if (err)
    {
        YLOG_GLOBAL(error) << "socket::set_option (SO_KEEPALIVE): " << err.message();
        err.clear();
    }

    // unportable settings
    int opt;
    using namespace ::boost::system;
#ifdef SOL_TCP
    if (!settings.no_keep_alive)
    {
        ;
#ifdef SOL_TCP
        // keep alive configuration
#if defined(TCP_KEEPIDLE) || defined(TCP_KEEPALIVE)
        opt = settings.tcp_keep_idle;

#if defined(TCP_KEEPIDLE)
#define SERVPLATF_TCP_KEEPIDLE TCP_KEEPIDLE
#else
#define SERVPLATF_TCP_KEEPIDLE TCP_KEEPALIVE
#endif
        if (opt != -1)
        {
            if (::setsockopt(
                    socket.native_handle(), SOL_TCP, SERVPLATF_TCP_KEEPIDLE, &opt, sizeof(opt)) ==
                -1)
                err = boost::system::errc::make_error_code(boost::system::errc::errc_t(errno));
            if (err)
            {
                YLOG_GLOBAL(error) << "::setsockopt (TCP_KEEPIDLE): " << err.message();
                err.clear();
            }
        }
#undef SERVPLATF_TCP_KEEPIDLE
#endif
#endif

#if defined(TCP_KEEPINTVL)
        opt = settings.tcp_keep_intvl;
        if (opt != -1)
        {
            if (::setsockopt(socket.native_handle(), SOL_TCP, TCP_KEEPINTVL, &opt, sizeof(opt)) ==
                -1)
                err = boost::system::errc::make_error_code(boost::system::errc::errc_t(errno));
            if (err)
            {
                YLOG_GLOBAL(error) << "::setsockopt (TCP_KEEPINTVL): " << err.message();
                err.clear();
            }
        }
#endif

#if defined(TCP_KEEPCNT)
        opt = settings.tcp_keep_cnt;
        if (opt != -1)
        {
            if (::setsockopt(socket.native_handle(), SOL_TCP, TCP_KEEPCNT, &opt, sizeof(opt)) == -1)
                err = boost::system::errc::make_error_code(boost::system::errc::errc_t(errno));
            if (err)
            {
                YLOG_GLOBAL(error) << "::setsockopt (TCP_KEEPCNT): " << err.message();
                err.clear();
            }
        }
#endif
    }

    // FIN_WAIT2 timeout
#if defined(TCP_LINGER2)
    opt = settings.tcp_linger2;
    if (opt != -1)
    {
        if (::setsockopt(socket.native_handle(), SOL_TCP, TCP_LINGER2, &opt, sizeof(opt)) == -1)
            err = boost::system::errc::make_error_code(boost::system::errc::errc_t(errno));
        if (err)
        {
            YLOG_GLOBAL(error) << "::setsockopt (TCP_LINGER2): " << err.message();
            err.clear();
        }
    }
#endif
#endif
}

}}
