#pragma once

#include <yplatform/net/filter.h>
#include <utility>

namespace yplatform { namespace net {

class line_filter : public proto_filter
{
private:
    struct filter_data
    {
        filter_data() : current_packet_size_(0), max_packet_size_(0), limit_exceed_(false)
        {
        }

        std::size_t current_packet_size_;
        std::size_t max_packet_size_;
        bool limit_exceed_;
    };
    typedef boost::shared_ptr<filter_data> data_ptr;

public:
    line_filter() : data_(new filter_data())
    {
    }

    line_filter(const line_filter& lf) : data_(lf.data_)
    {
    }

    void operator=(const line_filter& lf)
    {
        data_ = lf.data_;
    }

    template <typename Iterator>
    std::pair<Iterator, bool> operator()(Iterator begin, Iterator end)
    {
        for (Iterator i = begin; i != end; ++i)
        {
            data_->limit_exceed_ =
                (data_->max_packet_size_ > 0 &&
                 ++data_->current_packet_size_ > data_->max_packet_size_);
            if (is_limit_exceed() || *i == '\n')
            {
                data_->current_packet_size_ = 0;
                return std::make_pair(i, true);
            }
        }
        return std::make_pair(end, false);
    }

    void set_limit(std::size_t max_packet_size)
    {
        data_->max_packet_size_ = max_packet_size;
    }

    bool is_limit_exceed() const
    {
        return data_->limit_exceed_;
    }

private:
    data_ptr data_;
};

}}

namespace boost { namespace asio {
template <>
struct is_match_condition<yplatform::net::line_filter> : public boost::true_type
{
};
}}
