#pragma once
#include <boost/thread.hpp>

namespace yplatform { namespace net {

template <typename Handler, typename Mutex = boost::mutex, typename Lock = boost::lock_guard<Mutex>>
class mutex_wrap_helper
{
public:
    typedef Handler handler_type;
    typedef Mutex mutex_type;
    typedef Lock lock_type;
    typedef void result_type;

protected:
    inline mutex_type& mutex() const
    {
        return mutex_;
    }

    struct null_lock_type
    {
        null_lock_type(mutex_type&)
        {
        }
        ~null_lock_type(){};
    };

public:
    mutex_wrap_helper(handler_type&& h, mutex_type& m)
        : handler_(static_cast<handler_type&&>(h)), mutex_(m)
    {
    }

    mutex_wrap_helper(const mutex_wrap_helper& other)
        : handler_(other.handler_), mutex_(other.mutex_)
    {
    }

    mutex_wrap_helper(mutex_wrap_helper&& other)
        : handler_(static_cast<handler_type&&>(other.handler_)), mutex_(other.mutex_)
    {
    }

    void operator()()
    {
        null_lock_type lock(this->mutex());
        handler_();
    }

    void operator()() const
    {
        null_lock_type lock(this->mutex());
        handler_();
    }

    template <typename A0>
    void operator()(A0 a0)
    {
        null_lock_type lock(this->mutex());
        handler_(a0);
    }

    template <typename A0>
    void operator()(A0 a0) const
    {
        null_lock_type lock(this->mutex());
        handler_(a0);
    }

    template <typename A0, typename A1>
    void operator()(A0 a0, A1 a1)
    {
        null_lock_type lock(this->mutex());
        handler_(a0, a1);
    }

    template <typename A0, typename A1>
    void operator()(A0 a0, A1 a1) const
    {
        null_lock_type lock(this->mutex());
        handler_(a0, a1);
    }

    template <typename A0, typename A1, typename A2>
    void operator()(A0 a0, A1 a1, A2 a2)
    {
        null_lock_type lock(this->mutex());
        handler_(a0, a1, a2);
    }

    template <typename A0, typename A1, typename A2>
    void operator()(A0 a0, A1 a1, A2 a2) const
    {
        null_lock_type lock(this->mutex());
        handler_(a0, a1, a2);
    }

    template <typename Function>
    void invoke_lock(Function& func)
    {
        // REALLY use lock here
        lock_type lock(this->mutex());
        func();
    }

    template <typename Function>
    void invoke_lock(const Function& func)
    {
        // REALLY use lock here
        lock_type lock(this->mutex());
        func();
    }

private:
    typename std::remove_reference<handler_type>::type handler_;
    mutex_type& mutex_;
};

template <typename Handler, typename Mutex>
mutex_wrap_helper<Handler, Mutex> mutex_wrap(Handler&& handler, Mutex& mutex)
{
    return mutex_wrap_helper<Handler, Mutex>(static_cast<Handler&&>(handler), mutex);
}

template <typename Function, typename Handler, typename Mutex, typename Lock>
inline void asio_handler_invoke(
    Function& function,
    mutex_wrap_helper<Handler, Mutex, Lock>* this_handler)
{
    this_handler->invoke_lock(function);
}

template <typename Function, typename Handler, typename Mutex, typename Lock>
inline void asio_handler_invoke(
    const Function& function,
    mutex_wrap_helper<Handler, Mutex, Lock>* this_handler)
{
    this_handler->invoke_lock(function);
}

}} // namespace yplatform::net
