#pragma once

#include <yplatform/net/ssl_settings.h>
#include <yplatform/net/thread_safe_set.h>
#include <yplatform/net/types.h>
#include <yplatform/net/io_data.h>
#include <yplatform/net/context.h>
#include <yplatform/reactor.h>
#include <yplatform/net/io_service.h>
#include <yplatform/log.h>
#include <boost/asio.hpp>
#include <boost/thread.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/bind.hpp>
#include <memory>
#include <sys/syscall.h> // gettid
#include <sys/types.h>   // pid_t

namespace yplatform { namespace net {

template <typename Session, typename StatsCont = service_stats>
class net_service : public log::contains_logger
{
public:
    typedef Session session_t;
    typedef net_service<Session, StatsCont> this_t;
    typedef io_service io_service_t;
    typedef typename Session::protocol_t protocol_t;
    typedef boost::shared_ptr<session_t> session_ptr;
    typedef StatsCont service_stats_t;
    typedef boost::shared_ptr<service_stats_t> service_stats_ptr;

    net_service(const ::yplatform::reactor_ptr& reactor);
    virtual ~net_service();

    // for backward compatibility
    void run()
    {
    }
    void stop()
    {
    }

    void create_ssl_context(const ssl_settings& settings)
    {
        io_service_.create_ssl_context(settings);
    }

    void setup_dns(const dns::resolver_service_settings& settings)
    {
        io_service_.setup_dns(settings);
    }

    virtual void stats(std::size_t sent, std::size_t received)
    {
        stats_->bytes_sent += sent;
        stats_->bytes_received += received;
    }

    const service_stats_ptr& stats() const
    {
        return stats_;
    }

protected:
    io_service_t& get_io_pool()
    {
        return io_service_;
    }

    virtual void core_register_session(session_ptr /*session*/)
    {
    }
    virtual void core_unregister_session(session_ptr /*session*/)
    {
    }

private:
    void stop_service();

    io_service_t io_service_;
    service_stats_ptr stats_;
    string service_name_;
};

template <typename Session, typename StatsCont>
net_service<Session, StatsCont>::net_service(const ::yplatform::reactor_ptr& reactor)
    : io_service_(reactor), stats_(new service_stats_t)
{
    io_service_.init();
}

template <typename Session, typename StatsCont>
net_service<Session, StatsCont>::~net_service()
{
}

}}
