#pragma once

#include <yplatform/log.h>
#include <yplatform/active_object.h>
#include <boost/asio/handler_type.hpp>
#include <boost/system/error_code.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/make_shared.hpp>

namespace yplatform { namespace net { namespace detail {

template <class Hook>
struct ao_asio_wrapper
{
    Hook hook_;
    yactive_object* ao_;

    ao_asio_wrapper(Hook const& h) : hook_(h), ao_(yactive_object::tls_accessor())
    {
    }

    void operator()()
    {
        bool ret;
        if (!ao_ || !(ret = ao_->enqueue_method(ytask(hook_))))
        {
            hook_();
        }
        show_debug(ret, "hook()");
    }

    // Connect hook
    template <typename A0>
    void operator()(const A0& a0)
    {
        bool ret;
        if (!ao_ || !(ret = ao_->enqueue_method(ytask(boost::bind<void>(hook_, a0)))))
        {
            hook_(a0);
        }
        show_debug(ret, "hook(a0)");
    }

    // Resolve hook
    template <typename A0, typename A1>
    void operator()(const A0& a0, const A1& a1)
    {
        bool ret;
        if (!ao_ || !(ret = ao_->enqueue_method(ytask(boost::bind<void>(hook_, a0, a1)))))
        {
            hook_(a0, a1);
        }
        show_debug(ret, "hook(a0, a1)");
    }

    void show_debug(bool enqueu_ret, const char* hook)
    {
        if (!ao_)
        {
            YLOG_G(debug) << "not in AO, execute " << hook << " in io_service::run";
        }
        else if (!enqueu_ret)
        {
            YLOG_G(debug) << "AO<" << ao_->name() << "> is busy, execute " << hook
                          << " in io_service::run";
        }
        else
        {
            YLOG_G(debug) << "AO<" << ao_->name() << "> enqueue " << hook;
        }
    }
};
}}}

#endif
