#pragma once

#include <boost/function.hpp>
#include <boost/shared_ptr.hpp>

namespace yplatform { namespace net {

class passive_receiver
{
public:
    typedef boost::function<void(const boost::system::error_code&, std::size_t)> handler_t;

    virtual ~passive_receiver()
    {
    }
    virtual void async_read(handler_t cb, char* buff, std::size_t size, std::size_t min = 1) = 0;
    virtual std::size_t available() const = 0;
    virtual bool is_open() const = 0;
};

typedef boost::shared_ptr<passive_receiver> passive_receiver_ptr;

}}
