#pragma once

#include <yplatform/net/session_strand.h>
#include <yplatform/net/settings.h>

namespace yplatform { namespace net {

template <typename Settings = server_settings, typename Protocol = boost::asio::ip::tcp>
class server_session_strand
    : public session_strand<Settings, Protocol>
    , public streamable
{
public:
    typedef session_strand<Settings, Protocol> base_t;

    server_session_strand(io_data* io_data, const Settings& settings)
        : base_t(io_data, settings, boost::asio::ssl::stream_base::server)
    {
    }

    /// XXX unsafe call
    virtual bool is_open() const
    {
        return this->raw_socket().is_open();
    }
};

}}
