#pragma once

#include <yplatform/ptree.h>
#include <yplatform/net/config.h>
#include <boost/asio/ssl.hpp>

namespace yplatform { namespace net {

struct ssl_settings
{
    string password;
    string cert_file;
    string key_file;
    string cert;
    string key;
    string dh_file;
    boost::asio::ssl::context::verify_mode verify_mode = 0;
    string verify_file;
    boost::asio::ssl::context::options options = 0;
    string ciphers_list;
    bool prefer_server_ciphers = false;
    // sslv23 is a deprecated method, the meaning is: "use ssl2, ssl2, tls*".
    // @todo use special value for TLS_method when boost asio ssl will support it
    boost::asio::ssl::context::method method = boost::asio::ssl::context::sslv23;
    bool only_tls = true;
    int named_curve_id = 0;
    bool reduce_excess_buffers = false;
    size_t reduced_buffer_size = 8 * 1024;

    void parse_ptree(const yplatform::ptree& data)
    {
        cert_file = data.get("cert_file", cert_file);
        dh_file = data.get("dh_file", dh_file);
        key_file = data.get("key_file", key_file);
        password = data.get("password", password);
        verify_mode = data.get("verify_mode", verify_mode);
        verify_file = data.get("verify_file", verify_file);
        options = data.get("options", options);
        ciphers_list = data.get("ciphers_list", ciphers_list);
        prefer_server_ciphers = data.get("prefer_server_ciphers", prefer_server_ciphers);
        // deduce method (a bug with deprecated sslv23 for client connections)
        string method_str = data.get("method", "");
        if (method_str == "tlsv1")
        {
            method = boost::asio::ssl::context::tlsv1;
        }
        else if (method_str == "tlsv1_1")
        {
            method = boost::asio::ssl::context::tlsv11;
        }
        else if (method_str == "tlsv1_2")
        {
            method = boost::asio::ssl::context::tlsv12;
        }
        only_tls = data.get("only_tls", only_tls);
        auto named_curve_str = data.get("named_curve", "");
        if (!named_curve_str.empty())
        {
            if ((named_curve_id = OBJ_sn2nid(named_curve_str.c_str())) == 0)
            {
                throw std::logic_error("unknown ECC curve name");
            }
        }
        reduce_excess_buffers = data.get("reduce_excess_buffers", reduce_excess_buffers);
        reduced_buffer_size = data.get("reduced_buffer_size", reduced_buffer_size);
    }
};

}}
