#pragma once

#include <yplatform/net/config.h>
#include <yplatform/application/task_context.h> // module_stats
#include <boost/unordered_map.hpp>
#include <boost/thread/mutex.hpp>
#include <boost/shared_ptr.hpp>
#include <atomic>

namespace yplatform { namespace net {

struct service_stats : public module_stats
{
    std::atomic<uint64_t> bytes_sent;
    std::atomic<uint64_t> bytes_received;

    service_stats() : bytes_sent(0), bytes_received(0)
    {
    }

    service_stats(uint64_t bytes_sent_, uint64_t bytes_received_)
        : bytes_sent(bytes_sent_), bytes_received(bytes_received_)
    {
    }

    void update_io_counters(uint64_t sent, uint64_t received)
    {
        bytes_sent += sent;
        bytes_received += received;
    }

protected:
    virtual ptree_ptr core_get_stat() const
    {
        ptree_ptr result = module_stats::core_get_stat();

        result->put("bytes_sent", bytes_sent);
        result->put("bytes_received", bytes_received);

        return result;
    }
};

typedef boost::shared_ptr<service_stats> service_stats_ptr;

struct session_stats : public module_task_context
{
    std::atomic<uint64_t> bytes_sent;
    std::atomic<uint64_t> bytes_received;

    session_stats() : bytes_sent(0), bytes_received(0)
    {
    }

    session_stats(std::size_t bytes_sent_, std::size_t bytes_received_)
        : bytes_sent(bytes_sent_), bytes_received(bytes_received_)
    {
    }

    void set_service_stats(service_stats_ptr aservice_stats)
    {
        service_stats_ = aservice_stats;
    }

    void update_io_counters(uint64_t sent, uint64_t received)
    {
        bytes_sent += sent;
        bytes_received += received;
        if (service_stats_) service_stats_->update_io_counters(sent, received);
    }

protected:
    virtual ptree_ptr core_get_stat() const
    {
        ptree_ptr result = module_task_context::core_get_stat();

        result->put("bytes_sent", bytes_sent);
        result->put("bytes_received", bytes_received);

        return result;
    }

    service_stats_ptr service_stats_;
};

typedef boost::shared_ptr<session_stats> session_stats_ptr;

}}
